/**************************************************************************//**
 * @file        system_A9139M0.c
 * @version     V1.00.00
 * $Revision:   0 $
 * $Date:       2020-11-13 $
 * @brief       
 *
 * @note
 *
 * Copyright (C) 2020 AMICCOM Electronics Corp. All rights reserved.
 *****************************************************************************/

#include "system_A9139M0.h"
#include "Delay.h"

/*----------------------------------------------------------------------------
  DEFINES
 *----------------------------------------------------------------------------*/

/*----------------------------------------------------------------------------
  Define clocks
 *----------------------------------------------------------------------------*/


/*----------------------------------------------------------------------------
  Clock Variable definitions
 *----------------------------------------------------------------------------*/
Uint32 SystemCoreClock = XTAL;    /*!< Processor Clock Frequency            */

/**
 *
 * @brief  Write the data (write_data) to the register of address is reg_addr
 *
 * @param  reg_addr     the address of register
 *
 * @return write_data   the data of write
 * 
 */
void A9139M0_Reg_Write ( Uint32 reg_addr, Uint32 write_data )
{
    Uint32 masked;

    switch ( reg_addr )
    {
        case 0x50000004:        //FPCTL
        case 0x50000008:        //PWRCTL1
        case 0x5000000C:        //PWRCTL2
        case 0x50000014:        //DCDC_Ctrl1
        case 0x50000018:        //DCDC_Ctrl2
        case 0x5000001C:        //DCDC_Ctrl3
        case 0x50000024:        //DCDC_Ctrl4
        case 0x50000028:        //IO_Ctrl0
        case 0x5000002C:        //IO_Ctrl1
        case 0x50000030:        //IO_Ctrl2
        case 0x50000034:        //IO_Ctrl3
				case 0x50000038:        //IO_Ctrl4
				case 0x50000050:        //IO_Ctrl5
        case 0x50000054:        //IO_Ctrl6
        case 0x50000058:        //IO_Ctrl7
        case 0x5000005C:        //IO_Ctrl8
				case 0x50000060:        //ECC_CTL
				case 0x50000064:        //ECC_AHAL
				case 0x50000070:        //RFBR
				case 0x50000074:        //RC_Ctrl1
        case 0x50000078:        //RC_Ctrl2
				case 0x5000007C:        //DCDC_Ctrl5
				case 0x50000080:        //WDogCFG
				case 0x500000A0:        //WDogCFG
				case 0x500000A4:        //WDogCFG
            masked = __disable_irq();
            POWER->PWR_TA = 0xAAAAAAAA;
            POWER->PWR_TA = 0x55555555;
            HW32_REG ( reg_addr ) = write_data;
            if ( !masked )
                __enable_irq();
            break;
				case 0x500011C4:        //CLOCK1
				case 0x500011C8:        //CLOCK2            
            HW32_REG ( reg_addr ) = write_data;						
            Delay10us(1);
            break;
				default:
            HW32_REG ( reg_addr ) = write_data;
            break;
    }
}

/**
 * Initialize the system
 *
 * @param  none
 * @return none
 *
 * @brief  Setup the microcontroller system.
 *         Initialize the System.
 */
void SystemInit ( void )
{
  SystemCoreClock = XTAL;
}
